(function() {

// usage: copy this to '.banner.js' in your webroot,
// and run copyparty with the following arguments:
// --js-browser /.banner.js  --js-other /.banner.js



// had to pick the most chuuni one as the default
var bannertext = '' +
'<h3>This service is provided without warranty nor guarantee of anything.</h3>' +
'<p>Your files might disappear, they might be corrupted or they might duplicate. Who knows what will happen.</p>' +
'<p>Also, by signing in - you agree that your files do not break Finnish nor German law.</p>' +
'<p>There\'s also no guarantee that someone couldn\'t somehow see your files even when they\'re passkey protected - after all - the cloud is just other people\'s computers.</p>' +
'<p>In other news, I hope you get use out of this and if you have issues / suggestions / removal requests please contact <a href="https://layer8.space/@k">me</a>.</p>' +
'<p>Last updated: Tue Oct 1 01:04:49 AM EEST 2024</p>';



// fancy div to insert into pages
function bannerdiv(border) {
    var ret = mknod('div', null, bannertext);
    if (border)
        ret.setAttribute("style", "border:1em solid var(--fg); border-width:.3em 0; margin:3em 0");
    return ret;
}



// keep all of these false and then selectively enable them in the if-blocks below
var show_msgbox = false,
    login_top = false,
    top = false,
    bottom = false,
    top_bordered = false,
    bottom_bordered = false;

if (QS("h1#cc") && QS("a#k")) {
    // this is the controlpanel
    // (you probably want to keep just one of these enabled)
    show_msgbox = true;
    login_top = true;
    bottom = true;
}
else if (ebi("swin") && ebi("smac")) {
    // this is the connect-page, same deal here
    show_msgbox = true;
    top_bordered = true;
    bottom_bordered = true;
}
else if (ebi("op_cfg") || ebi("div#mw") ) {
    // we're running in the main filebrowser (op_cfg) or markdown-viewer/editor (div#mw),
    // fragile pages which break if you do something too fancy
    show_msgbox = true;
}



// shows a fullscreen messagebox; works on all pages
if (show_msgbox) {
    var now = Math.floor(Date.now() / 1000),
        last_shown = sread("bannerts") || 0;

    // 60 * 60 * 17 = 17 hour cooldown
    if (now - last_shown > 60 * 60 * 17) {
        swrite("bannerts", now);
        modal.confirm(bannertext, null, function () {
            location = 'https://this-page-intentionally-left-blank.org/';
        });
    }
}

// show a message on the page footer; only works on the connect-page
if (top || top_bordered) {
    var dst = ebi('wrap');
    dst.insertBefore(bannerdiv(top_bordered), dst.firstChild);
}

// show a message on the page footer; only works on the controlpanel and connect-page
if (bottom || bottom_bordered) {
    ebi('wrap').appendChild(bannerdiv(bottom_bordered));
}

// show a message on the top of the page; only works on the controlpanel
if (login_top) {
    var dst = QS('h1');
    dst.parentNode.insertBefore(bannerdiv(false), dst);
}

})();
